<?php
require '../config/sessionToken.php'; // Assuming this has the logic to verify session tokens
require_once '../config/constants.php';


// Function to get all classes
function getClasses($pdo) {
    $sessionToken = $_COOKIE['session_token'] ?? '';

    // Verify the session token
    $isValid = Token::Verify($sessionToken, APP_KEY);
    $isValidResponse = json_decode($isValid, true);
    if ($isValidResponse['headers']['status'] == 'failed') {
        return json_encode($isValidResponse);
    }

    // Prepare and execute the SQL query
    $stmt = $pdo->prepare("SELECT * FROM class");
    $stmt->execute();
    $classes = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Check if there are any results
    if ($classes) {
        return json_encode([
            'headers' => [
                'status' => 'success',
                'responseCode' => 200,
                'message' => 'Classes retrieved successfully'
            ],
            'body' => [
                'classes' => $classes
            ]
        ]);
    } else {
        return json_encode([
            'headers' => [
                'status' => 'success',
                'responseCode' => 404,
                'message' => 'No classes found'
            ],
            'body' => [
                'classes' => []
            ]
        ]);
    }
}

// Call the function to get all classes
echo getClasses($pdo);
?>

