<?php
require '../config/sessionToken.php'; // Assuming this has the logic to verify session tokens
require_once '../config/constants.php';

// Function to get test yourself questions
function getTestYourselfQuestions($data, $pdo) {
    $sessionToken = $_COOKIE['session_token'] ?? '';

    // Verify the session token
    $isValid = Token::Verify($sessionToken, APP_KEY);
    $isValidResponse = json_decode($isValid, true);
    if ($isValidResponse['headers']['status'] == 'failed') {
        return json_encode($isValidResponse);
    }

    // Check if class_name and subject_name are provided
    if (empty($data['class_name']) || empty($data['subject_name'])) {
        return json_encode([
            'headers' => [
                'status' => FAILED,
            'responseCode' => MISSING_REQUIRED_FIELDS,
            'message' => MISSING_REQUIRED_FIELDS_TEXT
            ]
        ]);
    }

    // Check if class exists
    $stmt = $pdo->prepare("SELECT id FROM class WHERE class_name = :class_name");
    $stmt->bindParam(':class_name', $data['class_name']);
    $stmt->execute();
    if ($stmt->rowCount() == 0) {
        return json_encode([
            'headers' => [
                'status' => FAILED,
                'responseCode' => CLASS_DOES_NOT_EXIST_CODE,
                'message' => CLASS_DOES_NOT_EXIST
            ]
        ]);
    }

    // Check if subject exists for the class
    $stmt = $pdo->prepare("SELECT id FROM subjects WHERE subject_name = :subject_name AND class_name = :class_name");
    $stmt->bindParam(':subject_name', $data['subject_name']);
    $stmt->bindParam(':class_name', $data['class_name']);
    $stmt->execute();
    if ($stmt->rowCount() == 0) {
        return json_encode([
            'headers' => [
                'status' => FAILED,
                'responseCode' => SUBJECT_DOES_NOT_EXIST_FOR_CLASS_CODE,
                'message' => SUBJECT_DOES_NOT_EXIST_FOR_CLASS
            ]
        ]);
    }

    // Prepare the query to fetch questions
    $query = "SELECT * FROM testyourselfquestions WHERE class_name = :class_name AND subject_name = :subject_name";
    
    // Add chapter_name filter if provided
    if (!empty($data['chapter_name'])) {
        $query .= " AND chapter_name = :chapter_name";
    }

    $stmt = $pdo->prepare($query);
    $stmt->bindParam(':class_name', $data['class_name']);
    $stmt->bindParam(':subject_name', $data['subject_name']);

    // Bind chapter_name if provided
    if (!empty($data['chapter_name'])) {
        $stmt->bindParam(':chapter_name', $data['chapter_name']);
    }

    $stmt->execute();
    $questions = $stmt->fetchAll(PDO::FETCH_ASSOC);

    return json_encode([
        'headers' => [
            'status' => SUCCESS,
            'responseCode' => COMMON_SUCCESS,
            'message' => QUESTION_RETERIVED_SUCCESS
        ],
        'body' => [
            'questionsList' => $questions
            ]
    ]);
}

// Function to get the Authorization token from headers
function getAuthorizationToken() {
    $headers = getallheaders();
    return isset($headers['Authorization']) ? trim(str_replace('Bearer ', '', $headers['Authorization'])) : null;
}

// Get input data from the POST request
$input = json_decode(file_get_contents('php://input'), true);

$locale = $input['locale'] ?? 'en';


    if ($locale === 'bn') {
        require_once '../config/app_bn.php';
    } else {
        require_once '../config/app_en.php';
    }


// If no data is provided, return an error
if (empty($input)) {
    echo json_encode([
        'headers' => [
            'status' => FAILED,
            'responseCode' => MISSING_REQUIRED_FIELDS,
            'message' => MISSING_REQUIRED_FIELDS_TEXT
        ]
    ]);
    exit();
}

// Call the function to get test yourself questions
echo getTestYourselfQuestions($input, $pdo);
