<?php
require '../config/sessionToken.php';
require_once '../config/constants.php';

function validateSessionToken() {
    $sessionToken = $_COOKIE['session_token'] ?? '';

    if (empty($sessionToken)) {
        echo json_encode([
            'status' => FAILED,
            'message' => MISSING_SESSION_TOKEN,
            'responseCode' => MISSING_SESSION_TOKEN_AUTH
        ]);
        exit();
    }

    $isValid = Token::Verify($sessionToken, APP_KEY);
    $isValidResponse = json_decode($isValid, true);

    if ($isValidResponse['headers']['status'] !== 'success') {
        echo json_encode([
            'status' => FAILED,
            'message' => SESSION_TIME_EXCEEDED_MSG,
            'responseCode' => SESSION_TIME_EXCEEDED
        ]);
        exit();
    }

    return $sessionToken;
}

function validateOtpHandler($pdo) {
    $sessionToken = validateSessionToken();

    $input = json_decode(file_get_contents('php://input'), true);
    $mobile = $input['mobile'] ?? '';
    $otp = $input['otp'] ?? '';
    $locale = $input['locale'] ?? 'en';

if ($locale === 'bn') {
    require_once '../config/app_bn.php';
} else {
    require_once '../config/app_en.php';
}


    if (empty($mobile) || empty($otp)) {
        echo json_encode([
            'status' => FAILED,
            'message' => MOB_OTP_REQUIRED,
            'responseCode' => MOB_OTP_REQUIRED_CODE
        ]);
        return;
    }

    // Fetch the OTP request from the database
    $stmt = $pdo->prepare("SELECT * FROM otp_requests WHERE mobile = :mobile AND session_token = :session_token");
    $stmt->execute(['mobile' => $mobile, 'session_token' => $sessionToken]);
    $otpRequest = $stmt->fetch();

    if (!$otpRequest) {
        echo json_encode([
            'status' => FAILED,
            'message' => NO_OTP_REQUEST_FOUND,
            'responseCode' => NO_OTP_REQUEST_FOUND_CODE
        ]);
        return;
    }

    // Check if the OTP has expired (older than 5 minutes)
    $otpCreatedAtTimestamp = strtotime($otpRequest['created_at']);
    $currentTimestamp = time();

    if (($currentTimestamp - $otpCreatedAtTimestamp) > 300) { // 300 seconds = 5 minutes
        echo json_encode([
            'status' => FAILED,
            'message' => OTP_EXPIRED,
            'responseCode' => OTP_EXPIRED_CODE
        ]);
        return;
    }

    // Validate the OTP
    if ($otpRequest['otp'] !== $otp) {
        echo json_encode([
            'status' => FAILED,
            'message' => INVALID_OTP,
            'responseCode' => INVALID_OTP_CODE
        ]);
        return;
    }

    // If OTP is valid, you can proceed with your logic (e.g., mark as validated)
    echo json_encode([
        'status' => SUCCESS,
        'message' => OTP_VALIDATED_SUCCESS,
        'responseCode' => OTP_VALIDATED_SUCCESS_CODE
    ]);

    // Optionally, mark the OTP as used or delete the OTP record after validation
    $stmt = $pdo->prepare("DELETE FROM otp_requests WHERE mobile = :mobile AND session_token = :session_token");
    $stmt->execute(['mobile' => $mobile, 'session_token' => $sessionToken]);
}

// Call the validate OTP handler
validateOtpHandler($pdo);
?>
