<?php
session_start();
require 'sessionToken.php';
// Get headers from the request
$headers = getallheaders();

// Check if required headers are set
$sessionId = $headers['Session-Id'] ?? session_id(); // Use session_id() for active sessions

$payload = ['id' => session_id()];
$token = Token::Sign($payload, APP_KEY);
$token_response = json_decode($token, true);

if ($token_response['headers']['status'] == SUCCESS) {
    setcookie("session_token", $token_response['body']['token'], [
        'expires' => time() + 3600, // 1 hour expiration
        'path' => '/',
        'domain' => '', // Allow across subdomains
        'secure' => true, // Send only over HTTPS
        'httponly' => true, // Prevent access via JavaScript
        'samesite' => 'None' // Required for cross-origin requests
    ]);

    // Use echo to output JSON response
    echo json_encode([
        'headers' => [
            'status' => 'success',
            'responseCode' => '200',
            'message' => 'Token generated'
        ]
    ]);
} else {
    // Use echo to output JSON response
    echo json_encode([
        'headers' => [
            'status' => 'failed',
            'responseCode' => '1004',
            'message' => 'Failed to generate token',
        ]
    ]);
}
?>
